/*! \file    
**********************************************************************************	
* Title:						Discretix SST utility API Source file						 					
*																			
* Filename:						sst_api_utility.c															
*																			
* Project, Target, subsystem:	SST 6.0, utility, API
* 
* Created:						21.08.2007														
*								
* Modified:						21.08.2007										
*								
* \Author						Einat Ron														
*																			
* \Remarks						
*           Copyright (C) 2006 by Discretix Technologies Ltd. All Rights reserved.
**********************************************************************************/

/*----------- External include files ----------------------------------------*/
#include "DX_VOS_Mem.h"
#include "dx_hw_defs.h"
#include "sst_host_op_code.h"
/*----------- Local include files -------------------------------------------*/
#include "sst_utility.h"
  

  
/*---------------------------------------------------------------------------*/
/*               API FUNCTIONS                                               */
/*---------------------------------------------------------------------------*/


        /*SST_DataTypeGet*/
DxError_t SST_DataTypeGet(SSTHandle_t aDataHandle,SSTDataType_t *aDataType_ptr)
{
	
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_DATA_TYPE_GET, 3,
	   							 /* PARAMETERS: */
                                   aDataHandle,
                                   aDataType_ptr );
}


/*SST_WorkspaceSizeGet*/
DxError_t SST_WorkspaceSizeGet(SSTWorkspaceOp_t aWorkspaceOp,DxUint32_t *aWorkspaceMinSize_ptr)
{
	
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_WORKSPACE_SIZE_GET, 2,
	   							 /* PARAMETERS: */
                                   aWorkspaceOp,
                                   aWorkspaceMinSize_ptr );
}

/* SST_DataHandleBuild */
DxError_t SST_DataHandleBuild(SSTDataType_t aDataType,SSTObjectId_t aDataObjID,SSTHandle_t *aDataHandle_ptr)
{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_DATA_HANDLE_BUILD, 3,
	   							 /* PARAMETERS: */
                                   aDataType,
                                   aDataObjID,
                                   aDataHandle_ptr );
}


/* SST_UtilNVSSizesGet */
DxError_t SST_UtilNVSSizesGet(DxNvsMemoryId_t aMemoryID, 
                              DxUint32_t      *aMaxSizeInBytes_ptr,
                              DxUint32_t      *aUsedSizeInBytes_ptr)
{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_NVS_SIZE_GET, 3,
	   							 /* PARAMETERS: */
                                   aMemoryID,
                                   aMaxSizeInBytes_ptr,
                                   aUsedSizeInBytes_ptr );
}/* end of SST_UtilNVSSizesGet */
 

/* SST_VDBUtilNVSMaxSizeSet */
DxError_t SST_UtilNVSMaxSizeSet(DxNvsMemoryId_t aMemoryID, 
                                DxUint32_t      aNewMaxSizeInBytes)
{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_NVS_MAX_SIZE_SET, 2,
	   							 /* PARAMETERS: */
                                   aMemoryID,
                                   aNewMaxSizeInBytes );
} /* end of SST_VDBUtilNVSMaxSizeSet */
